( function( $ ) {
    var WidgetDomainSearchHandler = function( $scope, $ ) {
        var globalTimeout = null;  

		$(".iddomainname").on("change keyup paste", function(e){
			e.stopImmediatePropagation();
			//console.log(e);
				var selector = $(this);
				var domainname = selector.val();
				var searchmethod= $(this).siblings('input[name=domain_search_method]').val();
				
				if (domainname.indexOf('.') !== -1){

					  if (globalTimeout != null) {
					    clearTimeout(globalTimeout);
					  }

					    globalTimeout = setTimeout(function() {
					    globalTimeout = null;  

							$.ajax({
									    method: "POST",
									    url: domainjs_texts.ajaxurl,
									    dataType: 'json',
									    data: { 'action': 'void_ewhmcsep_ajax_domain_function', 'domain': domainname, 'searchmethod':searchmethod }
							})

							.done(function( data ) {
								//console.log(data);
							  	//var json = JSON.stringify(data);
								//var data = JSON.parse(data);
								
								//console.log('Successful AJAX Call! /// Return Data: ' + data['registered?']);
								//console.log(data);
							   	if(data.status=='unavailable'){  
							   		selector.closest('.sda-form-area').find( '#find' ).val(domainjs_texts.button_unavailable).removeClass('btn-available btn-info').addClass('btn-unavailable').prop('disabled', true);
							   		selector.closest('.sda-form-area').find('#results').html('<span class="domain-unavailable">'+ domainjs_texts.domain_unavailable +'</span>');
							   	}	
							   	else if(data.status=='available'){  
							   		selector.closest('.sda-form-area').find( '#find' ).val(domainjs_texts.button_available).removeClass('btn-unavailable btn-info').addClass('btn-available').prop('disabled', false);
							   		selector.closest('.sda-form-area').find('#results').html('<span class="domain-available">'+ domainjs_texts.domain_available +'</span>');
							   	}
							   	else{
							   		selector.closest('.sda-form-area').find( '#find' ).val(domainjs_texts.button_info).removeClass('btn-unavailable btn-available').addClass('btn-info').prop('disabled', false);
							   		if(data.is_admin){
							   			selector.closest('.sda-form-area').find('#results').html('<small style="color:red;">This message is not visible visitors</small><br><span class="domain-info">'+ JSON.stringify(data) +'</span>');
							   		}else{
							   			selector.closest('.sda-form-area').find('#results').html('<span class="domain-info">'+ 'Ajax search is not working, Please contact site Admin' +'</span>');
							   		}
							   
							   	}

							})

							.fail(function( data ) {
								   // document.getElementById("results").innerHTML = 'Ajax Failed'; 
							});
					  }, 300);  


						
				}
					
			});

    };
    
    var WidgetDomainTableHandler = function( $scope, $ ) {
        
		$(".void-ewhmcsep-domain-table-search").on("keyup paste", function(){
				var selector = $(this).parent();
				var rows = selector.next();
				rows = $('tr:not(:first-child)',rows);
				if($(this).hasClass("dotallowed")){
					var typed_tld = $(this).val();
					if( typed_tld[0] != '.' ){
						typed_tld = '.' + typed_tld;
					}
 					var val = '^(?=' +$.trim( typed_tld ).split(/\s+/).join('\\b)(?=.*\\b') + ').*$',
			        reg = RegExp(val, 'i'),
			        text;

				}else{
					var val = '^(?=.*\\b' + $.trim($(this).val()).split(/\s+/).join('\\b)(?=.*\\b') + ').*$',
			        reg = RegExp(val, 'i'),
			        text;
				}
			    
			    rows.show().filter(function() {
			        text = $(this).text().replace(/\s+/g, ' ');
			        return !reg.test(text);
			    }).hide();
					
		});

    };
    
	
    // Make sure you run this code under Elementor..
    $( window ).on( 'elementor/frontend/init', function() {
        elementorFrontend.hooks.addAction( 'frontend/element_ready/section-domain-search.default', WidgetDomainSearchHandler );
        elementorFrontend.hooks.addAction( 'frontend/element_ready/section-domain-price.default', WidgetDomainTableHandler );
    } );
} )( jQuery );